/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;

class SamplesView
extends Canvas {
    public static int EDIT_NONE = 0;
    public static int EDIT_DRAW = 1;
    public static int EDIT_ZERO = 2;
    public static int EDIT_CONST = 3;
    public static int EDIT_RECT = 4;
    public static int EDIT_NEGATE = 5;
    public static int EDIT_SHIFT = 6;
    public static int PROP_NONE = 0;
    public static int PROP_SAMPLE = 1;
    public static int PROP_MAGNITUDE = 2;
    public static int PROP_PHASE = 3;
    public Samples samples;
    private int property = PROP_NONE;
    private int editMode = EDIT_DRAW;
    private int sampleStart;
    private int sampleBase;
    private int sampleWidth;
    private int sampleRadius;
    private float sampleScale;
    private float sampleValue;
    private int lastDrag;
    private int lastY;

    public SamplesView(Samples samples, int n) {
        this.samples = samples;
        this.property = n;
        samples.view = this;
        this.setSampleValue(1.0f);
        this.updateDrawingSizes();
        if (n == PROP_NONE) {
            this.setBackground(Color.lightGray);
        } else if (n == PROP_SAMPLE) {
            Color color = new Color(255, 255, 240);
            this.setBackground(color);
        } else if (n == PROP_MAGNITUDE) {
            Color color = new Color(255, 255, 128);
            this.setBackground(color);
        } else if (n == PROP_PHASE) {
            Color color = new Color(200, 200, 128);
            this.setBackground(color);
        }
    }

    public void setSampleValue(float f) {
        int n = this.size().height;
        this.sampleValue = f != 0.0f ? f : 1.0f;
        this.sampleScale = -0.25f * (float)n / this.sampleValue;
    }

    public void setEditMode(int n) {
        this.editMode = n;
    }

    public void paint(Graphics graphics) {
        this.updateDrawingSizes();
        this.drawSamples(graphics, 0, this.samples.values.length);
    }

    public Dimension minimumSize() {
        return new Dimension(100, 50);
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.editMode == EDIT_NONE) {
            return true;
        }
        this.lastDrag = -1;
        this.lastY = 0;
        return this.mouseDrag(event, n, n2);
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.editMode == EDIT_NONE) {
            return true;
        }
        if (n < 0 || n > this.size().width) {
            return true;
        }
        if (n2 < this.sampleRadius || n2 > this.size().height - this.sampleRadius) {
            return true;
        }
        int n3 = (int)((double)((float)(n - this.sampleStart) / (float)this.sampleWidth) + 0.5);
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 >= this.samples.values.length) {
            n3 = this.samples.values.length - 1;
        }
        if (this.editMode == EDIT_NEGATE && n3 == this.lastDrag) {
            return true;
        }
        Graphics graphics = this.getGraphics();
        if (this.lastDrag >= 0) {
            if (this.editMode == EDIT_ZERO) {
                graphics.setColor(this.getBackground());
                this.drawSamples(graphics, n3, this.lastDrag);
                this.samples.zero(n3, this.lastDrag);
                graphics.setColor(this.getForeground());
                this.drawSamples(graphics, n3, this.lastDrag);
            } else if (this.editMode == EDIT_CONST) {
                graphics.setColor(this.getBackground());
                this.drawSamples(graphics, n3, this.lastDrag);
                this.samples.constant(n3, this.lastDrag, this.samples.getMax());
                graphics.setColor(this.getForeground());
                this.drawSamples(graphics, n3, this.lastDrag);
            } else if (this.editMode == EDIT_RECT) {
                graphics.setColor(this.getBackground());
                this.drawSamples(graphics, n3, this.lastDrag);
                this.samples.rectify(n3, this.lastDrag);
                graphics.setColor(this.getForeground());
                this.drawSamples(graphics, n3, this.lastDrag);
            } else if (this.editMode == EDIT_NEGATE) {
                graphics.setColor(this.getBackground());
                this.drawSamples(graphics, n3, this.lastDrag);
                this.samples.negate(n3, this.lastDrag);
                if (this.property == PROP_MAGNITUDE) {
                    int n4 = 0;
                    while (n4 < this.samples.values.length) {
                        if ((double)this.samples.values[n4] < 0.0) {
                            this.samples.values[n4] = 0.0f;
                        }
                        ++n4;
                    }
                }
                graphics.setColor(this.getForeground());
                this.drawSamples(graphics, n3, this.lastDrag);
            } else if (this.editMode == EDIT_SHIFT) {
                graphics.setColor(this.getBackground());
                this.drawSamples(graphics, 0, this.samples.values.length);
                this.samples.rotate(n3 - this.lastDrag);
                graphics.setColor(this.getForeground());
                this.drawSamples(graphics, 0, this.samples.values.length);
            } else {
                graphics.setColor(this.getBackground());
                this.drawSamples(graphics, n3, this.lastDrag);
                this.samples.draw(n3, this.lastDrag, n2, this.lastY, this.sampleBase, this.sampleScale);
                if (this.property == PROP_MAGNITUDE) {
                    int n5 = 0;
                    while (n5 < this.samples.values.length) {
                        if ((double)this.samples.values[n5] < 0.0) {
                            this.samples.values[n5] = 0.0f;
                        }
                        ++n5;
                    }
                }
                graphics.setColor(this.getForeground());
                this.drawSamples(graphics, n3, this.lastDrag);
            }
        }
        this.lastDrag = n3;
        this.lastY = n2;
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.editMode != EDIT_NONE) {
            this.samples.notifyObservers();
        }
        return true;
    }

    private void drawOneSample(Graphics graphics, int n) {
        int n2 = this.sampleStart + n * this.sampleWidth;
        int n3 = this.sampleBase;
        int n4 = this.sampleRadius;
        int n5 = this.sampleWidth;
        int n6 = (int)(this.samples.values[n] * this.sampleScale);
        graphics.drawLine(n2 - n5 / 2, n3, n2 + n5 / 2, n3);
        graphics.drawLine(n2, n3, n2, n3 + n6);
        if (n == this.samples.origin) {
            graphics.drawOval(n2 - n4, n3 + n6 - n4, 2 * n4, 2 * n4);
        } else {
            graphics.fillOval(n2 - n4, n3 + n6 - n4, 2 * n4 + 1, 2 * n4 + 1);
        }
    }

    private void drawSamples(Graphics graphics, int n, int n2) {
        int n3;
        if (n > n2) {
            n3 = n;
            n = n2;
            n2 = n3;
        }
        if (n2 > this.samples.values.length) {
            n2 = this.samples.values.length;
        }
        if (n < 0) {
            n = 0;
        }
        if (n == n2) {
            this.drawOneSample(graphics, n);
            return;
        }
        n3 = n;
        while (n3 < n2) {
            this.drawOneSample(graphics, n3);
            ++n3;
        }
    }

    private void updateDrawingSizes() {
        int n = this.size().width;
        int n2 = this.size().height;
        int n3 = this.samples.values.length;
        this.sampleWidth = (int)((float)n / (float)(n3 + 1));
        this.sampleStart = (n - (n3 - 1) * this.sampleWidth) / 2;
        this.sampleBase = (int)(0.5f * (float)n2);
        this.sampleScale = -0.25f * (float)n2 / this.sampleValue;
        this.sampleRadius = (int)(0.4f * (float)this.sampleWidth);
        int n4 = (int)(0.5f * (float)n2);
        if (this.sampleRadius > n4) {
            this.sampleRadius = n4;
        }
    }
}

