/*
 * Decompiled with CFR 0.152.
 */
import java.util.Observable;
import java.util.Observer;

class FftLabController
implements Observer {
    public Samples fReal;
    public Samples fImag;
    public Samples gReal;
    public Samples gImag;
    public Samples gMag;
    public Samples gPha;
    public SamplesView fRealView;
    public SamplesView fImagView;
    public SamplesView gRealView;
    public SamplesView gImagView;
    public SamplesView gMagView;
    public SamplesView gPhaView;
    private int editMode = SamplesView.EDIT_DRAW;
    private int length = 32;
    private boolean originCentered = false;

    public FftLabController() {
        int n = this.originCentered ? this.length / 2 : 0;
        this.fReal = new Samples(this.length, n);
        this.fImag = new Samples(this.length, n);
        this.gReal = new Samples(this.length, n);
        this.gImag = new Samples(this.length, n);
        this.gMag = new Samples(this.length, n);
        this.gPha = new Samples(this.length, n);
        this.initSamples();
        this.fReal.addObserver(this);
        this.fImag.addObserver(this);
        this.gReal.addObserver(this);
        this.gImag.addObserver(this);
        this.gMag.addObserver(this);
        this.gPha.addObserver(this);
        this.fRealView = new SamplesView(this.fReal, SamplesView.PROP_SAMPLE);
        this.fImagView = new SamplesView(this.fImag, SamplesView.PROP_NONE);
        this.gRealView = new SamplesView(this.gReal, SamplesView.PROP_NONE);
        this.gImagView = new SamplesView(this.gImag, SamplesView.PROP_NONE);
        this.gMagView = new SamplesView(this.gMag, SamplesView.PROP_MAGNITUDE);
        this.gPhaView = new SamplesView(this.gPha, SamplesView.PROP_PHASE);
        this.updateSampleValues(this.fRealView, this.fImagView);
        this.updateSampleValues(this.gRealView, this.gImagView);
        this.updateMagPhaValues(this.gMagView, this.gPhaView);
    }

    public int getEditMode() {
        return this.editMode;
    }

    public void setEditMode(int n) {
        this.editMode = n;
        this.fRealView.setEditMode(n);
        this.fImagView.setEditMode(n);
        this.gRealView.setEditMode(n);
        this.gImagView.setEditMode(n);
        this.gMagView.setEditMode(n);
        this.gPhaView.setEditMode(n);
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int n) {
        this.length = n;
        this.updateLengths();
        this.updateOrigins();
        this.initSamples();
        this.updateSampleValues(this.fRealView, this.fImagView);
        this.updateSampleValues(this.gRealView, this.gImagView);
        this.updateMagPhaValues(this.gMagView, this.gPhaView);
        this.repaintViews();
    }

    public boolean getOriginCentered() {
        return this.originCentered;
    }

    public void setOriginCentered(boolean bl) {
        if (bl == this.originCentered) {
            return;
        }
        this.originCentered = bl;
        this.updateOrigins();
        this.repaintViews();
    }

    public void zeroAll() {
        this.fReal.zero(0, this.getLength());
        this.fImag.zero(0, this.getLength());
        this.gReal.zero(0, this.getLength());
        this.gImag.zero(0, this.getLength());
        this.gMag.zero(0, this.getLength());
        this.gPha.zero(0, this.getLength());
        this.repaintViews();
    }

    public void update(Observable observable, Object object) {
        Samples samples = (Samples)observable;
        if (samples == this.fReal || samples == this.fImag) {
            this.transform(1, this.fReal, this.fImag, this.gReal, this.gImag);
            this.rect2polar(this.gReal, this.gImag, this.gMag, this.gPha);
        } else if (samples == this.gReal || samples == this.gImag) {
            this.transform(-1, this.gReal, this.gImag, this.fReal, this.fImag);
            this.rect2polar(this.gReal, this.gImag, this.gMag, this.gPha);
        } else {
            this.polar2rect(this.gMag, this.gPha, this.gReal, this.gImag);
            this.transform(-1, this.gReal, this.gImag, this.fReal, this.fImag);
        }
        this.updateMagPhaValues(this.gMagView, this.gPhaView);
        this.updateSampleValues(this.gRealView, this.gImagView);
        this.updateSampleValues(this.fRealView, this.fImagView);
        this.fRealView.repaint();
        this.fImagView.repaint();
        this.gRealView.repaint();
        this.gImagView.repaint();
        this.gMagView.repaint();
        this.gPhaView.repaint();
    }

    private float computeSampleValue(Samples samples, Samples samples2) {
        float f = 0.0f;
        float[] fArray = samples.values;
        int n = 0;
        while (n < this.length) {
            float f2 = fArray[n];
            if (-f2 > f) {
                f = -f2;
            } else if (f2 > f) {
                f = f2;
            }
            ++n;
        }
        fArray = samples2.values;
        int n2 = 0;
        while (n2 < this.length) {
            float f3 = fArray[n2];
            if (-f3 > f) {
                f = -f3;
            } else if (f3 > f) {
                f = f3;
            }
            ++n2;
        }
        return f;
    }

    private float computeSampleMax(Samples samples) {
        float f = 0.0f;
        float[] fArray = samples.values;
        int n = 0;
        while (n < this.length) {
            float f2 = fArray[n];
            if (-f2 > f) {
                f = -f2;
            } else if (f2 > f) {
                f = f2;
            }
            ++n;
        }
        return f;
    }

    private void updateSampleValues(SamplesView samplesView, SamplesView samplesView2) {
        float f = this.computeSampleValue(samplesView.samples, samplesView2.samples);
        samplesView.setSampleValue(f);
        samplesView2.setSampleValue(f);
    }

    private void updateMagPhaValues(SamplesView samplesView, SamplesView samplesView2) {
        float f = this.computeSampleMax(samplesView.samples);
        float f2 = this.computeSampleMax(samplesView2.samples);
        samplesView.setSampleValue(f);
        samplesView2.setSampleValue(f2);
    }

    private void transform(int n, Samples samples, Samples samples2, Samples samples3, Samples samples4) {
        int n2;
        float[] fArray = samples.values;
        float[] fArray2 = samples2.values;
        float[] fArray3 = samples3.values;
        float[] fArray4 = samples4.values;
        int n3 = 0;
        while (n3 < this.length) {
            fArray3[n3] = fArray[n3];
            fArray4[n3] = fArray2[n3];
            ++n3;
        }
        if (this.originCentered) {
            n2 = 1;
            while (n2 < this.length) {
                fArray3[n2] = -fArray3[n2];
                fArray4[n2] = -fArray4[n2];
                n2 += 2;
            }
        }
        Fft.complexToComplex(n, this.length, fArray3, fArray4);
        if (this.originCentered) {
            n2 = 1;
            while (n2 < this.length) {
                fArray3[n2] = -fArray3[n2];
                fArray4[n2] = -fArray4[n2];
                n2 += 2;
            }
        }
    }

    private void rect2polar(Samples samples, Samples samples2, Samples samples3, Samples samples4) {
        float[] fArray = samples.values;
        float[] fArray2 = samples2.values;
        float[] fArray3 = samples3.values;
        float[] fArray4 = samples4.values;
        int n = 0;
        while (n < this.length) {
            fArray3[n] = (float)Math.sqrt(fArray[n] * fArray[n] + fArray2[n] * fArray2[n]);
            fArray4[n] = (float)Math.atan2(fArray2[n], fArray[n]);
            ++n;
        }
    }

    private void polar2rect(Samples samples, Samples samples2, Samples samples3, Samples samples4) {
        float[] fArray = samples.values;
        float[] fArray2 = samples2.values;
        float[] fArray3 = samples3.values;
        float[] fArray4 = samples4.values;
        int n = 0;
        while (n < this.length) {
            fArray3[n] = fArray[n] * (float)Math.cos(fArray2[n]);
            fArray4[n] = fArray[n] * (float)Math.sin(fArray2[n]);
            ++n;
        }
    }

    private void initSamples() {
        this.fReal.values[this.fReal.origin + 1] = 1.0f;
        this.transform(1, this.fReal, this.fImag, this.gReal, this.gImag);
        this.rect2polar(this.gReal, this.gImag, this.gMag, this.gPha);
    }

    private void updateLengths() {
        int n = this.length;
        this.fReal.setLength(n);
        this.fImag.setLength(n);
        this.gReal.setLength(n);
        this.gImag.setLength(n);
        this.gMag.setLength(n);
        this.gPha.setLength(n);
    }

    private void updateOrigins() {
        int n = this.originCentered ? this.length / 2 : 0;
        int n2 = n - this.fReal.origin;
        this.fReal.origin = n;
        this.fImag.origin = n;
        this.gReal.origin = n;
        this.gImag.origin = n;
        this.gMag.origin = n;
        this.gPha.origin = n;
        this.fReal.rotate(n2);
        this.fImag.rotate(n2);
        this.gReal.rotate(n2);
        this.gImag.rotate(n2);
        this.gMag.rotate(n2);
        this.gPha.rotate(n2);
    }

    private void repaintViews() {
        this.fRealView.repaint();
        this.fImagView.repaint();
        this.gRealView.repaint();
        this.gImagView.repaint();
        this.gMagView.repaint();
        this.gPhaView.repaint();
    }

    private void shiftSamples(Samples samples, int n) {
        float[] fArray = new float[this.length];
        int n2 = n % this.length;
        int n3 = 0;
        while (n3 < this.length) {
            if (n2 < 0) {
                n2 += this.length;
            }
            if (n2 >= this.length) {
                n2 -= this.length;
            }
            fArray[n2] = samples.values[n3];
            ++n3;
            ++n2;
        }
        samples.values = fArray;
    }
}

