/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;

class ControlPanel
extends Panel {
    private FftLabController c;
    private LabeledChoice length;
    private LabeledChoice mode;

    public ControlPanel(FftLabController fftLabController) {
        this.c = fftLabController;
        this.add(new Checkbox("Origin Centered"));
        this.length = new LabeledChoice("Length:");
        this.length.choice.addItem("16");
        this.length.choice.addItem("32");
        this.length.choice.addItem("64");
        this.length.choice.addItem("128");
        this.length.choice.select("32");
        this.add(this.length);
        this.mode = new LabeledChoice("Editing:");
        this.mode.choice.addItem("Draw");
        this.mode.choice.addItem("Negate");
        this.mode.choice.addItem("Zero");
        this.mode.choice.addItem("Constant");
        this.mode.choice.addItem("Rectify");
        this.mode.choice.addItem("Shift");
        this.mode.choice.addItem("None");
        this.mode.choice.select("Draw");
        this.add(this.mode);
        this.add(new Button("Zero All"));
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.size();
        graphics.setColor(Color.darkGray);
        graphics.draw3DRect(0, 0, dimension.width - 1, dimension.height - 1, true);
    }

    public Insets insets() {
        return new Insets(1, 1, 1, 1);
    }

    public boolean handleEvent(Event event) {
        if (event.target instanceof Button) {
            this.c.zeroAll();
            return true;
        }
        if (event.target instanceof Checkbox) {
            Checkbox checkbox = (Checkbox)event.target;
            this.c.setOriginCentered(checkbox.getState());
            return true;
        }
        if (event.target instanceof Choice) {
            if (event.target == this.length.choice) {
                String string = this.length.choice.getSelectedItem();
                this.c.setLength(Integer.parseInt(string));
                return true;
            }
            if (event.target == this.mode.choice) {
                String string = this.mode.choice.getSelectedItem();
                if (string == "None") {
                    this.c.setEditMode(SamplesView.EDIT_NONE);
                } else if (string == "Draw") {
                    this.c.setEditMode(SamplesView.EDIT_DRAW);
                } else if (string == "Negate") {
                    this.c.setEditMode(SamplesView.EDIT_NEGATE);
                } else if (string == "Zero") {
                    this.c.setEditMode(SamplesView.EDIT_ZERO);
                } else if (string == "Constant") {
                    this.c.setEditMode(SamplesView.EDIT_CONST);
                } else if (string == "Rectify") {
                    this.c.setEditMode(SamplesView.EDIT_RECT);
                } else if (string == "Shift") {
                    this.c.setEditMode(SamplesView.EDIT_SHIFT);
                }
                return true;
            }
        }
        return false;
    }
}

